/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.uddi.inquiry_v2.uddi_org;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.ws.listener.uddi.api_v2.uddi_org.BindingDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.BindingKey;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessDetailExt;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessKey;
import filenet.ws.listener.uddi.api_v2.uddi_org.BusinessList;
import filenet.ws.listener.uddi.api_v2.uddi_org.CategoryBag;
import filenet.ws.listener.uddi.api_v2.uddi_org.DispositionReport;
import filenet.ws.listener.uddi.api_v2.uddi_org.FindQualifiers;
import filenet.ws.listener.uddi.api_v2.uddi_org.Find_binding;
import filenet.ws.listener.uddi.api_v2.uddi_org.Find_business;
import filenet.ws.listener.uddi.api_v2.uddi_org.Find_relatedBusinesses;
import filenet.ws.listener.uddi.api_v2.uddi_org.Find_service;
import filenet.ws.listener.uddi.api_v2.uddi_org.Find_tModel;
import filenet.ws.listener.uddi.api_v2.uddi_org.Get_bindingDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.Get_businessDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.Get_businessDetailExt;
import filenet.ws.listener.uddi.api_v2.uddi_org.Get_serviceDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.Get_tModelDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.IdentifierBag;
import filenet.ws.listener.uddi.api_v2.uddi_org.KeyedReference;
import filenet.ws.listener.uddi.api_v2.uddi_org.Name;
import filenet.ws.listener.uddi.api_v2.uddi_org.RelatedBusinessesList;
import filenet.ws.listener.uddi.api_v2.uddi_org.ServiceDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.ServiceKey;
import filenet.ws.listener.uddi.api_v2.uddi_org.ServiceList;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModel;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModelDetail;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModelList;
import filenet.ws.listener.uddi.api_v2.uddi_org.Truncated;
import filenet.ws.listener.uddi.inquiry_v2.uddi_org.Inquire;
import filenet.ws.listener.uddi.inquiry_v2.uddi_org.WSUddiManager;
import java.rmi.RemoteException;

public class InquireSoapImpl
implements Inquire {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.uddi");
    protected static final String m_className = "InquireSoapImpl";

    public static String _get_FILE_DATE() {
        return "$Date:   02 Oct 2008 10:25:26  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }

    public BindingDetail find_binding(Find_binding body) throws RemoteException, DispositionReport {
        String m_method = "find_business";
        logger.entering(m_className, m_method);
        logger.exiting(m_className, m_method);
        return new BindingDetail();
    }

    public BusinessList find_business(Find_business body) throws RemoteException, DispositionReport {
        String m_method = "find_business";
        logger.entering(m_className, m_method);
        DispositionReport dr = null;
        try {
            BusinessList bl = null;
            boolean bNoMatch = false;
            boolean bTruncated = false;
            if (body != null) {
                KeyedReference[] kr;
                IdentifierBag ib;
                KeyedReference[] kr2;
                CategoryBag cb = body.getCategoryBag();
                if (cb != null && (kr2 = cb.getKeyedReference()) != null && kr2.length > 0) {
                    for (int i = 0; i < kr2.length; ++i) {
                        if (kr2[0] == null || kr2[0].equals(TModel.wsdlSpecKeyedReference)) continue;
                        bNoMatch = true;
                    }
                }
                if (!bNoMatch && (ib = body.getIdentifierBag()) != null && (kr = ib.getKeyedReference()) != null && kr.length > 0) {
                    bNoMatch = true;
                }
                if (!bNoMatch && body.getMaxRows() != -1 && body.getMaxRows() < 1) {
                    bNoMatch = true;
                    bTruncated = true;
                }
                if (!bNoMatch && !bTruncated) {
                    Name[] names;
                    boolean bExactMatch = false;
                    boolean bCaseSensitive = false;
                    FindQualifiers fqs = body.getFindQualifiers();
                    if (fqs != null) {
                        String[] sFqs = fqs.getFindQualifier();
                        bExactMatch = fqs.getExactNameMatch();
                        bCaseSensitive = fqs.getCaseSensitiveMatch();
                    }
                    if ((names = body.getName()).length > 5) {
                        VWException ex = new VWException("filenet.ws.listener.uddi.inquiry_v2.uddi_org.InquireSoapImpl.tooManyNames", "Too many names");
                        dr = new DispositionReport("E_tooManyOptions", 10030, ex.getLocalizedMessage());
                        throw ex;
                    }
                    String[] nameArray = null;
                    boolean bEmptyNames = true;
                    if (names != null && names.length > 0) {
                        nameArray = new String[names.length];
                        for (int i = 0; i < names.length; ++i) {
                            Name name = names[i];
                            if (name != null && name.getValue() != null && name.getValue().length() > 0) {
                                bEmptyNames = false;
                                nameArray[i] = name.getValue();
                                continue;
                            }
                            nameArray[i] = null;
                        }
                    }
                    if (bEmptyNames) {
                        VWException ex = new VWException("filenet.ws.listener.uddi.inquiry_v2.uddi_org.InquireSoapImpl.nullBusinessNameValue", "Business name value is null");
                        dr = new DispositionReport("E_unsupported", 10050, ex.getLocalizedMessage());
                        throw ex;
                    }
                    WSUddiManager uddiManager = WSUddiManager.getWSUddiManager();
                    bl = uddiManager.findBusiness(names, bCaseSensitive, bExactMatch);
                    uddiManager.cleanup();
                }
            }
            if (bl == null) {
                bl = new BusinessList();
            }
            if (bTruncated) {
                bl.setTruncated(Truncated.value1);
            }
            BusinessList businessList = bl;
            return businessList;
        }
        catch (VWException ex) {
            if (dr == null) {
                dr = new DispositionReport(ex.getLocalizedMessage());
            }
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public RelatedBusinessesList find_relatedBusinesses(Find_relatedBusinesses body) throws RemoteException, DispositionReport {
        return new RelatedBusinessesList();
    }

    public ServiceList find_service(Find_service body) throws RemoteException, DispositionReport {
        String m_method = "find_service";
        logger.entering(m_className, m_method);
        DispositionReport dr = null;
        try {
            if (body != null) {
                Name[] names = body.getName();
                BusinessKey bk = body.getBusinessKey();
                if (bk == null || bk.getValue() == null || bk.getValue().length() == 0) {
                    VWException ex = new VWException("filenet.ws.listener.uddi.inquiry_v2.uddi_org.InquireSoapImpl.missingBusinessKey", "Missing business key");
                    dr = new DispositionReport("E_invalidKeyPassed", 10210, ex.getLocalizedMessage());
                    throw ex;
                }
                String[] nameArray = null;
                boolean bEmptyNames = true;
                if (names != null && names.length > 0) {
                    nameArray = new String[names.length];
                    for (int i = 0; i < names.length; ++i) {
                        Name name = names[i];
                        if (name != null && name.getValue() != null && name.getValue().length() > 0) {
                            bEmptyNames = false;
                            nameArray[i] = name.getValue();
                            continue;
                        }
                        nameArray[i] = null;
                    }
                }
                if (bEmptyNames) {
                    VWException ex = new VWException("filenet.ws.listener.uddi.inquiry_v2.uddi_org.InquireSoapImpl.nullServiceNameValue", "Service name value is null");
                    dr = new DispositionReport("E_unsupported", 10050, ex.getLocalizedMessage());
                    throw ex;
                }
                FindQualifiers fqs = body.getFindQualifiers();
                boolean bExactMatch = fqs.getExactNameMatch();
                boolean bCaseSensitive = fqs.getCaseSensitiveMatch();
            }
            ServiceList sl = new ServiceList();
            sl.setGeneric("v2");
            sl.setOperator("FileNet");
            logger.exiting(m_className, m_method);
            ServiceList serviceList = sl;
            return serviceList;
        }
        catch (VWException ex) {
            if (dr == null) {
                dr = new DispositionReport(ex.getLocalizedMessage());
            }
            logger.throwing(m_className, m_method, ex);
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public TModelList find_tModel(Find_tModel body) throws RemoteException, DispositionReport {
        String m_method = "find_tModel";
        logger.entering(m_className, m_method);
        logger.entering(m_className, m_method);
        DispositionReport dr = null;
        try {
            TModelList tl = null;
            boolean bNoMatch = false;
            if (body != null) {
                KeyedReference[] kr;
                IdentifierBag ib;
                KeyedReference[] kr2;
                CategoryBag cb = body.getCategoryBag();
                if (cb != null && (kr2 = cb.getKeyedReference()) != null && kr2.length > 0) {
                    bNoMatch = true;
                }
                if (!bNoMatch && (ib = body.getIdentifierBag()) != null && (kr = ib.getKeyedReference()) != null && kr.length > 0) {
                    for (int i = 0; i < kr.length; ++i) {
                        if (kr[i] == null || TModel.wsdlSpecKeyedReference.equals(kr[i])) continue;
                        bNoMatch = true;
                        break;
                    }
                }
                if (!bNoMatch) {
                    Name name;
                    boolean bExactMatch = false;
                    boolean bCaseSensitive = false;
                    FindQualifiers fqs = body.getFindQualifiers();
                    if (fqs != null) {
                        String[] sFqs = fqs.getFindQualifier();
                        bExactMatch = fqs.getExactNameMatch();
                        bCaseSensitive = fqs.getCaseSensitiveMatch();
                    }
                    if ((name = body.getName()) == null || name.getValue() == null || name.getValue().trim().length() == 0) {
                        VWException ex = new VWException("filenet.ws.listener.uddi.inquiry_v2.uddi_org.InquireSoapImpl.nullTModelNameValue", "TModel name value is null");
                        dr = new DispositionReport("E_unsupported", 10050, ex.getLocalizedMessage());
                        throw ex;
                    }
                    WSUddiManager uddiManager = WSUddiManager.getWSUddiManager();
                    tl = uddiManager.findTModel(name, body.getMaxRows(), bCaseSensitive, bExactMatch);
                    uddiManager.cleanup();
                }
            }
            if (tl == null) {
                tl = new TModelList();
            }
            TModelList tModelList = tl;
            return tModelList;
        }
        catch (VWException ex) {
            if (dr == null) {
                dr = new DispositionReport(ex.getLocalizedMessage());
            }
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public BindingDetail get_bindingDetail(Get_bindingDetail body) throws RemoteException, DispositionReport {
        String m_method = "get_bindingDetail";
        try {
            WSUddiManager uddiManager;
            logger.entering(m_className, m_method);
            BindingDetail bd = null;
            if (body != null) {
                uddiManager = WSUddiManager.getWSUddiManager();
                if (uddiManager != null) {
                    BindingKey[] bk = body.getBindingKey();
                    bd = uddiManager.getBindingDetail(bk);
                } else if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "uddiManager is null");
                }
                if (bd == null) {
                    bd = new BindingDetail();
                }
                uddiManager.cleanup();
            }
            uddiManager = bd;
            return uddiManager;
        }
        catch (VWException ex) {
            DispositionReport dr = new DispositionReport(ex.getLocalizedMessage());
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public BusinessDetail get_businessDetail(Get_businessDetail body) throws RemoteException, DispositionReport {
        String m_method = "get_businessDetail";
        try {
            WSUddiManager uddiManager;
            logger.entering(m_className, m_method);
            BusinessDetail bd = null;
            if (body != null) {
                uddiManager = WSUddiManager.getWSUddiManager();
                if (uddiManager != null) {
                    BusinessKey[] bk = body.getBusinessKey();
                    bd = uddiManager.getBusinessDetail(bk);
                } else if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "uddiManager is null");
                }
                if (bd == null) {
                    bd = new BusinessDetail();
                }
                uddiManager.cleanup();
            }
            uddiManager = bd;
            return uddiManager;
        }
        catch (VWException ex) {
            DispositionReport dr = new DispositionReport(ex.getLocalizedMessage());
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public BusinessDetailExt get_businessDetailExt(Get_businessDetailExt body) throws RemoteException, DispositionReport {
        String m_method = "get_businessDetailExt";
        logger.entering(m_className, m_method);
        logger.exiting(m_className, m_method);
        return new BusinessDetailExt();
    }

    public ServiceDetail get_serviceDetail(Get_serviceDetail body) throws RemoteException, DispositionReport {
        String m_method = "get_serviceDetail";
        try {
            WSUddiManager uddiManager;
            logger.entering(m_className, m_method);
            ServiceDetail sd = null;
            if (body != null) {
                uddiManager = WSUddiManager.getWSUddiManager();
                if (uddiManager != null) {
                    ServiceKey[] sk = body.getServiceKey();
                    sd = uddiManager.getServiceDetail(sk);
                } else if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "uddiManager is null");
                }
                if (sd == null) {
                    sd = new ServiceDetail();
                }
                uddiManager.cleanup();
            }
            uddiManager = sd;
            return uddiManager;
        }
        catch (VWException ex) {
            DispositionReport dr = new DispositionReport(ex.getLocalizedMessage());
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public TModelDetail get_tModelDetail(Get_tModelDetail body) throws RemoteException, DispositionReport {
        String m_method = "get_tModelDetail";
        try {
            WSUddiManager uddiManager;
            logger.entering(m_className, m_method);
            TModelDetail td = null;
            if (body != null) {
                uddiManager = WSUddiManager.getWSUddiManager();
                td = uddiManager.getTModelDetail(body.getTModelKey());
                uddiManager.cleanup();
            }
            if (td == null) {
                td = new TModelDetail();
            }
            uddiManager = td;
            return uddiManager;
        }
        catch (VWException ex) {
            DispositionReport dr = new DispositionReport(ex.getLocalizedMessage());
            throw dr;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }
}

